<?php

/**
 * Class FactoryTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelRest\Response\UserWs\Version1\User\Delete;

use Sso\RestBundle\ModelRest\Common\Response\UserWs\ErrorCollector;
use Sso\RestBundle\ModelRest\Response\UserWs\Version1\User\Delete;
use PHPUnit\Framework\TestCase;

/**
 * Class FactoryTest
 * @package Sso\RestBundle\Tests\ModelRest\Response\UserWs\Version1\User\Add
 */
class FactoryTest extends TestCase
{
    /** @var Delete\Factory */
    private $factory;

    public function setUp()
    {
        $this->factory = new Delete\Factory();
        parent::setUp();
    }

    public function testError()
    {
        self::assertInstanceOf(ErrorCollector\Error::class, $this->factory->error());
    }

    public function testUserType()
    {
        self::assertInstanceOf(Delete\UserType::class, $this->factory->userType());
    }

    public function testResponse()
    {
        self::assertInstanceOf(Delete\Response::class, $this->factory->response());
    }
}
