<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelRest\Response\UserWs\Version1\UserApplication\Add;

use Sso\RestBundle\ModelRest\Common\Response\UserWs\ErrorCollector\Error;
use Sso\RestBundle\ModelRest\Response\UserWs\Version1\UserApplication\Add\Factory;
use Sso\RestBundle\ModelRest\Response\UserWs\Version1\UserApplication\Add\Response;
use Sso\RestBundle\ModelRest\Response\UserWs\Version1\UserApplication\Add\UserType;
use PHPUnit\Framework\TestCase;

/**
 * Class FactoryTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class FactoryTest extends TestCase
{
    /**
     * @var Factory
     */
    protected $factory;

    protected function setUp()
    {
        $this->factory = new Factory();
    }

    public function testUserType()
    {
        $this->assertInstanceOf(UserType::class, $this->factory->userType());
    }

    public function testError()
    {
        $this->assertInstanceOf(Error::class, $this->factory->error());
    }

    public function testResponse()
    {
        $this->assertInstanceOf(Response::class, $this->factory->response());
    }
}
