<?php

/**
 * Class FactoryTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelRest\Response\UserWs\Version1\UserApplicationRole;

use Sso\RestBundle\ModelRest\Response\UserWs\Version1\UserApplicationRole;
use PHPUnit\Framework\TestCase;

/**
 * Class FactoryTest
 * @package Sso\RestBundle\Tests\ModelRest\Response\UserWs\Version1\UserApplicationRole
 */
class FactoryTest extends TestCase
{
    /**
     * @var UserApplicationRole\Factory
     */
    private $factory;

    /**
     * {@inheritDoc}
     */
    public function setUp()
    {
        $this->factory = new UserApplicationRole\Factory();
    }

    public function testDeleteFactory()
    {
        static::assertInstanceOf(UserApplicationRole\Delete\Factory::class, $this->factory->delete());
    }

    public function testAddFactory()
    {
        static::assertInstanceOf(UserApplicationRole\Add\Factory::class, $this->factory->add());
    }
}
