<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelRest\Response\UserWs\Version1\UserService;

use Sso\RestBundle\ModelRest\Response\UserWs\Version1\UserService;
use PHPUnit\Framework\TestCase;

/**
 * Class FactoryTest
 * @package Sso\RestBundle\Tests\ModelRest\Response\UserWs\Version1\UserService
 */
class FactoryTest extends TestCase
{
    /**
     * @var UserService\Factory
     */
    private $factory;

    /**
     * {@inheritDoc}
     */
    public function setUp()
    {
        $this->factory = new UserService\Factory();
    }

    public function testActivateRequestFactory()
    {
        static::assertInstanceOf(UserService\ActivateRequest\Factory::class, $this->factory->activateRequest());
    }

    public function testActivateConfirmFactory()
    {
        static::assertInstanceOf(UserService\ActivateConfirm\Factory::class, $this->factory->activateConfirm());
    }

    public function testPasswordRequestFactory()
    {
        static::assertInstanceOf(UserService\PasswordRequest\Factory::class, $this->factory->passwordRequest());
    }

    public function testPasswordConfirmFactory()
    {
        static::assertInstanceOf(UserService\PasswordConfirm\Factory::class, $this->factory->passwordConfirm());
    }
}
