<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelRest\Response\UserWs\Version2\UserSearch;

use PHPUnit\Framework\TestCase;
use Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserSearch\Factory;
use Sso\RestBundle\ModelRest\Response\UserWS\Version2\UserSearch\Advanced\Factory as FactoryAdvanced;
use Sso\RestBundle\ModelRest\Response\UserWS\Version2\UserSearch\FindByApplication\Factory as FactoryFindByApplication;
use Sso\RestBundle\ModelRest\Response\UserWS\Version2\UserSearch\FindByApplicationAttribute\Factory as FactoryFindByApplicationAttribute;
use Sso\RestBundle\ModelRest\Response\UserWS\Version2\UserSearch\FindByApplicationRole\Factory as FactoryFindByApplicationRole;

/**
 * Class FactoryTest
 * @package Sso\RestBundle\Tests\ModelRest\Response\UserWs\Version2\UserSearch
 */
class FactoryTest extends TestCase
{
    /**
     * @var Factory
     */
    private $factory;

    protected function setUp()
    {
        $this->factory = new Factory();
    }

    public function testFactoryAdvanced()
    {
        $this->assertInstanceOf(FactoryAdvanced::class, $this->factory->advanced());
    }

    public function testFindByApplicationFactory()
    {
        $this->assertInstanceOf(FactoryFindByApplication::class, $this->factory->findByApplication());
    }

    public function testFindByApplicationAttributeFactory()
    {
        $this->assertInstanceOf(FactoryFindByApplicationAttribute::class, $this->factory->findByApplicationAttribute());
    }

    public function testFindByApplicationRoleFactory()
    {
        $this->assertInstanceOf(FactoryFindByApplicationRole::class, $this->factory->findByApplicationRole());
    }
}
