<?php

/**
 * Class FactoryTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Request\ObjectWs\Version1\AttributeGroup;

use Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\AttributeGroup;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

/**
 * Class FactoryTest
 * @package Sso\RestBundle\Tests\ModelXml\Request\ObjectWs\Version1\AttributeGroup
 */
class FactoryTest extends WebTestCase
{
    /**
     * @var AttributeGroup\Factory
     */
    private $factory;

    /**
     * {@inheritDoc}
     */
    public function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->factory = new AttributeGroup\Factory();
    }

    public function testDelete()
    {
        static::assertInstanceOf(AttributeGroup\Delete\Factory::class, $this->factory->delete());
    }

    public function testAdd()
    {
        static::assertInstanceOf(AttributeGroup\Add\Factory::class, $this->factory->add());
    }

    public function testShow()
    {
        static::assertInstanceOf(AttributeGroup\Show\Factory::class, $this->factory->show());
    }

    public function testUpdate()
    {
        static::assertInstanceOf(AttributeGroup\Update\Factory::class, $this->factory->update());
    }
}