<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Request\ObjectWs\Version1\AttributeGroup\Update;

use Sso\RestBundle\ModelXml\Common\Request\Credentials\ObjectWs\Credentials;
use Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\AttributeGroup\Update;
use PHPUnit\Framework\TestCase;

/**
 * Class FactoryTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class FactoryTest extends TestCase
{
    /**
     * @var Update\Factory
     */
    private $factory;

    protected function setUp()
    {
        $this->factory = new Update\Factory();
    }

    public function testRequestFactory()
    {
        static::assertInstanceOf(Update\Request::class, $this->factory->request());
    }

    public function testCredentialsFactory()
    {
        static::assertInstanceOf(Credentials::class, $this->factory->credentials());
    }

    public function testAddFactory()
    {
        static::assertInstanceOf(Update\AttributeGroup::class, $this->factory->attributeGroup());
    }
}
