<?php

/**
 * Test class ModelXml Request Object Factory
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Request\Object;

use GuzzleHttp\Client;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;
use Sso\RestBundle\Api;
use Sso\RestBundle\ModelXml;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Test class ModelXml Request Object Factory
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class FactoryTest extends WebTestCase
{

    /**
     *
     * @var Api\Manager
     */
    public $apiM;

    /**
     *
     * @var Client
     */
    protected $client;

    /**
     *
     * @var ContainerInterface
     */
    protected $container;

    protected function setUp()
    {
        $this->client = static::createClient();
        $this->container = $this->client->getContainer();
        $this->apiM = new Api\Manager($this->container);
    }

    public function testGetFactory()
    {
        // asserts
        $this->assertInstanceOf('\Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Object\Show\Factory',
            $this->apiM->modelXml()->request()->objectWs()->version1()->object()->show());
    }

    public function testPutFactory()
    {
        // asserts
        $this->assertInstanceOf('\Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Object\Add\Factory',
            $this->apiM->modelXml()->request()->objectWs()->version1()->object()->add());
    }
}
