<?php

/**
 * Class RequestTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Request\ObjectWs\Version1\Object\Update;

use Sso\RestBundle\ModelXml\Common\Request\Credentials\ObjectWs\Credentials;
use Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Object\Update\Request;
use Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Object\Update\Object;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;
use Sso\RestBundle\Api\Manager as ApiManager;
use JMS\Serializer\SerializerInterface;
use Faker\Factory as FakerFactory;
use Faker\Generator as FakerGenerator;

/**
 * Class RequestTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\RestBundle\Tests\ModelRest
 */
class RequestTest extends WebTestCase
{
    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @var ApiManager
     */
    private $apiManager;

    /**
     * @var FakerGenerator
     */
    private $faker;

    /**
     * @var string
     */
    private $serviceToken;

    /**
     * @var string
     */
    private $serviceName;

    /**
     * @var string
     */
    private $userIdentifier;

    /**
     * @var string
     */
    private $username;

    /**
     * @var string
     */
    private $langCode;

    /**
     * @var string
     */
    private $name;

    /**
     * @var string
     */
    private $description;

    /**
     * @var string
     */
    private $referenceId;

    /**
     * @var string
     */
    private $typeId;

    /**
     * @var string
     */
    private $guid;

    /**
     * @var int
     */
    private $active;

    protected function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->apiManager = new ApiManager(static::$kernel->getContainer());
        $this->serializer = $this->apiManager->serializer();
        $this->faker = FakerFactory::create();

        // Set same random data
        $this->serviceToken = $this->faker->sha256;
        $this->serviceName = $this->faker->word;
        $this->userIdentifier = $this->faker->md5;
        $this->username = $this->faker->userName;
        $this->langCode = $this->faker->languageCode;
        $this->name = $this->faker->name;
        $this->description = $this->faker->sentence();
        $this->referenceId = $this->faker->md5;
        $this->guid = $this->faker->uuid;
        $this->typeId = $this->faker->uuid;
        $this->active = $this->faker->boolean ? 1 : 0;
    }

    public function testSerialize()
    {
        $this->assertXmlStringEqualsXmlString($this->getRequestBody(), $this->setRequestBody());
    }

    /**
     * @return string
     */
    private function setRequestBody()
    {
        $request = new Request();
        $credentials = new Credentials();
        $object = new Object();

        $credentials->setCredentialsData(
            $this->serviceToken,
            $this->serviceName,
            $this->userIdentifier,
            $this->username,
            $this->langCode
        );

        $object->setObjectData(
            $this->guid,
            $this->referenceId,
            $this->typeId,
            $this->guid,
            $this->name,
            $this->active
        );

        $request->setCredentials($credentials);
        $request->setObject($object);

        return $this->serializer->serialize($request, 'xml');
    }

    /**
     * @return string
     */
    private function getRequestBody()
    {
        return '<SsoRequest>
            <Credentials>
                <ServiceProvider>
                    <ServiceToken>' . $this->serviceToken . '</ServiceToken>
                    <ServiceName>' . $this->serviceName . '</ServiceName>
                </ServiceProvider>
                <ServiceTrigger>
                    <UserIdentifier>' . $this->userIdentifier . '</UserIdentifier>
                    <Username>' . $this->username . '</Username>
                </ServiceTrigger>
                <ServiceCountry>
                    <Code>' . $this->langCode . '</Code>
                </ServiceCountry>
            </Credentials>
            <Object>
                <Update>
                    <ObjectType>
                        <Guid>' . $this->guid . '</Guid>
                        <ReferenceId>' . $this->referenceId . '</ReferenceId>
                        <TypeId>' . $this->typeId . '</TypeId>
                        <ParentGuid>' . $this->guid . '</ParentGuid>
                        <Name>' . $this->name . '</Name>
                        <Active>' . $this->active . '</Active>
                    </ObjectType>
                </Update>
            </Object>
        </SsoRequest>';
    }

    public function testGetterObjectType()
    {
        /** @var  Request $requestModel */
        $requestModel = $this->serializer->deserialize(
            $this->setRequestBody(),
            Request::class,
            'xml'
        );

        $objectType = $requestModel->getObject()->getUpdate()->getObjectType();
        $credentials = $requestModel->getCredentials();

        $this->assertEquals($this->guid, $objectType->getGuid());
        $this->assertEquals($this->referenceId, $objectType->getReferenceId());
        $this->assertEquals($this->typeId, $objectType->getTypeId());
        $this->assertEquals($this->guid, $objectType->getParentGuid());
        $this->assertEquals($this->name, $objectType->getName());
        $this->assertEquals($this->active, $objectType->getActive());
        $this->assertEquals($this->serviceToken, $credentials->getServiceProvider()->getServiceToken());
    }
}
