<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Request\ObjectWs\Version1\ObjectValue\Update;

use Sso\RestBundle\ModelXml\Common\Request\Credentials\ObjectWs\Credentials;
use Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectValue\Update\Request;
use Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectValue\Update\ObjectValue;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;
use Sso\RestBundle\Api\Manager as ApiManager;
use JMS\Serializer\SerializerInterface;
use Faker\Factory as FakerFactory;
use Faker\Generator as FakerGenerator;

/**
 * Class RequestTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\RestBundle\Tests\ModelRest
 */
class RequestTest extends WebTestCase
{
    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @var ApiManager
     */
    private $apiManager;

    /**
     * @var FakerGenerator
     */
    private $faker;

    /**
     * @var string
     */
    private $serviceToken;

    /**
     * @var string
     */
    private $serviceName;

    /**
     * @var string
     */
    private $userIdentifier;

    /**
     * @var string
     */
    private $username;

    /**
     * @var string
     */
    private $langCode;

    /**
     * @var string
     */
    private $id;

    /**
     * @var string
     */
    private $value;

    /**
     * @var string
     */
    private $languageCode;

    protected function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->apiManager = new ApiManager(static::$kernel->getContainer());
        $this->serializer = $this->apiManager->serializer();
        $this->faker = FakerFactory::create();

        // Set same random data
        $this->serviceToken = $this->faker->sha256;
        $this->serviceName = $this->faker->word;
        $this->userIdentifier = $this->faker->md5;
        $this->username = $this->faker->userName;
        $this->langCode = $this->faker->languageCode;
        $this->id = $this->faker->sha1;
        $this->value = $this->faker->word;
        $this->languageCode = $this->faker->languageCode;
    }

    public function testSerialize()
    {
        $this->assertXmlStringEqualsXmlString($this->getRequestBody(), $this->setRequestBody());
    }

    /**
     * @return string
     */
    private function setRequestBody()
    {
        $request = new Request();
        $credentials = new Credentials();
        $attributeGroup = new ObjectValue();

        $credentials->setCredentialsData(
            $this->serviceToken,
            $this->serviceName,
            $this->userIdentifier,
            $this->username,
            $this->langCode
        );

        $attributeGroup->setObjectValue(
            $this->id,
            $this->value,
            $this->languageCode
        );

        $request->setCredentials($credentials);
        $request->setObjectValue($attributeGroup);

        return $this->serializer->serialize($request, 'xml');
    }

    /**
     * @return string
     */
    private function getRequestBody()
    {
        return '<SsoRequest>
            <Credentials>
                <ServiceProvider>
                    <ServiceToken><![CDATA[' . $this->serviceToken . ']]></ServiceToken>
                    <ServiceName><![CDATA[' . $this->serviceName . ']]></ServiceName>
                </ServiceProvider>
                <ServiceTrigger>
                    <UserIdentifier><![CDATA[' . $this->userIdentifier . ']]></UserIdentifier>
                    <Username><![CDATA[' . $this->username . ']]></Username>
                </ServiceTrigger>
                <ServiceCountry>
                    <Code><![CDATA[' . $this->langCode . ']]></Code>
                </ServiceCountry>
            </Credentials>
            <ObjectValue>
                <Update>
                    <ObjectValueType>
                        <Id><![CDATA[' . $this->id . ']]></Id>
                        <Value><![CDATA[' . $this->value . ']]></Value>
                        <LanguageCode><![CDATA[' . $this->languageCode . ']]></LanguageCode>
                    </ObjectValueType>
                </Update>
            </ObjectValue>
        </SsoRequest>';
    }

    public function testGetters()
    {
        /** @var  Request $requestModel */
        $requestModel = $this->serializer->deserialize(
            $this->setRequestBody(),
            Request::class,
            'xml'
        );

        $objectValueType = $requestModel->getObjectValue()->getUpdate()->getObjectValueType();

        $credentials = $requestModel->getCredentials();

        $this->assertEquals($this->id, $objectValueType->getId());
        $this->assertEquals($this->value, $objectValueType->getValue());
        $this->assertEquals($this->languageCode, $objectValueType->getLanguageCode());
        $this->assertEquals($this->serviceToken, $credentials->getServiceProvider()->getServiceToken());
    }
}
