<?php

/**
 * Class FactoryTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Request\UserWs\UserWs\Version1\User\Add;

use Sso\RestBundle\ModelXml\Common\Request\Credentials\UserWs\Credentials;
use Sso\RestBundle\ModelXml\Request\UserWs\Version1\User\Add\Add;
use Sso\RestBundle\ModelXml\Request\UserWs\Version1\User\Add\Factory;
use Sso\RestBundle\ModelXml\Request\UserWS\Version1\User\Add\Request;
use Sso\RestBundle\ModelXml\Request\UserWs\Version1\User\Add\User;
use Sso\RestBundle\ModelXml\Request\UserWs\Version1\User\Add\UserType;
use PHPUnit\Framework\TestCase;

/**
 * Class FactoryTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\RestBundle\Tests\ModelRest
 */
class FactoryTest extends TestCase
{
    /**
     * @var Factory
     */
    protected $factory;

    protected function setUp()
    {
        $this->factory = new Factory();
    }

    public function testRequest()
    {
        $this->assertInstanceOf(Request::class, $this->factory->request());
    }

    public function testCredentials()
    {
        $this->assertInstanceOf(Credentials::class, $this->factory->credentials());
    }

    public function testAdd()
    {
        $this->assertInstanceOf(Add::class, $this->factory->add());
    }

    public function testUser()
    {
        $this->assertInstanceOf(User::class, $this->factory->user());
    }

    public function testUserType()
    {
        $this->assertInstanceOf(UserType::class, $this->factory->userType());
    }
}
