<?php

/**
 * Class FactoryTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Request\UserWs\UserWs\Version1\User\Delete;

use Sso\RestBundle\ModelXml\Common\Request\Credentials\UserWs\Credentials;
use Sso\RestBundle\ModelXml\Request\UserWs\Version1\User\Delete;
use PHPUnit\Framework\TestCase;

/**
 * Class FactoryTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\Tests\ModelXml\Request\UserWs\UserWs\Version1\User\Delete
 */
class FactoryTest extends TestCase
{
    /**
     * @var Delete\Factory
     */
    protected $factory;

    protected function setUp()
    {
        $this->factory = new Delete\Factory();
    }

    public function testRequest()
    {
        static::assertInstanceOf(Delete\Request::class, $this->factory->request());
    }

    public function testCredentials()
    {
        static::assertInstanceOf(Credentials::class, $this->factory->credentials());
    }

    public function testDelete()
    {
        static::assertInstanceOf(Delete\Delete::class, $this->factory->delete());
    }

    public function testUser()
    {
        static::assertInstanceOf(Delete\User::class, $this->factory->user());
    }

    public function testUserType()
    {
        static::assertInstanceOf(Delete\UserType::class, $this->factory->userType());
    }
}
