<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Request\UserWs\Version2\UserApplication;

use Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserApplication\Factory;
use Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserApplication\Show\Factory as ShowFactory;
use Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserApplication\ShowDetails\Factory as ShowDetailsFactory;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

/**
 * Class FactoryTest
 * @package Sso\RestBundle\Tests\ModelXml\Request\UserWs\Version2\UserApplication
 */
class FactoryTest extends WebTestCase
{
    /**
     * @var Factory
     */
    private $factory;

    public function setUp()
    {
        $this->factory = new Factory();
    }

    public function testShow()
    {
        static::assertInstanceOf(ShowFactory::class, $this->factory->show());
    }

    public function testShowDetails()
    {
        static::assertInstanceOf(ShowDetailsFactory::class, $this->factory->showDetails());
    }
}
