<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Request\UserWs\Version2\UserSearch;

use Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserSearch\Factory;
use Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserSearch\Advanced\Factory as AdvancedFactory;
use Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserSearch\FindByApplication\Factory as FindByApplicationFactory;
use Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserSearch\FindByApplicationAttribute\Factory as FindByApplicationAttributeFactory;
use Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserSearch\FindByApplicationRole\Factory as FindByApplicationRoleFactory;
use PHPUnit\Framework\TestCase;

/**
 * Class FactoryTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class FactoryTest extends TestCase
{
    /**
     * @var Factory
     */
    private $factory;

    protected function setUp()
    {
        $this->factory = new Factory();
    }

    public function testAdvancedFactory()
    {
        $this->assertInstanceOf(AdvancedFactory::class, $this->factory->advanced());
    }

    public function testFindByApplicationFactory()
    {
        $this->assertInstanceOf(FindByApplicationFactory::class, $this->factory->findByApplication());
    }

    public function testFindByApplicationAttributeFactory()
    {
        $this->assertInstanceOf(FindByApplicationAttributeFactory::class, $this->factory->findByApplicationAttribute());
    }

    public function testFindByApplicationRoleFactory()
    {
        $this->assertInstanceOf(FindByApplicationRoleFactory::class, $this->factory->findByApplicationRole());
    }
}
