<?php

/**
 * Class ResponseTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Response\ObjectWs\Version1\AttributeGroup\Update\Error;

use Sso\RestBundle\Api\Manager as ApiManager;
use Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\AttributeGroup\Update\Error;
use Faker\Factory as FakerFactory;
use Faker\Generator as FakerGenerator;
use JMS\Serializer\SerializerInterface;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

/**
 * Class ResponseTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\Tests\ModelRest\Response\ObjectWs\Version1\AttributeGroup\Update
 */
class ResponseTest extends WebTestCase
{
    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @var ApiManager
     */
    private $apiManager;

    /**
     * @var FakerGenerator
     */
    private $faker;

    /**
     * @var Error\Response
     */
    private $response;

    protected function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->apiManager = new ApiManager(static::$kernel->getContainer());
        $this->serializer = $this->apiManager->serializer();
        $this->faker = FakerFactory::create();

        $this->setUpResponse();
    }

    private function setUpResponse()
    {
        $response = new Error\Response();
        $attributeGroup = new Error\AttributeGroup();
        $update = new Error\Update();
        $error = new Error\Error();

        $error
            ->setErrorCode($this->faker->randomNumber())
            ->setErrorRef($this->faker->sha1)
            ->setLongMessage($this->faker->text(100))
            ->setShortMessage($this->faker->text(50));

        $update
            ->setError($error)
            ->setStatus($this->faker->text(10));

        $attributeGroup
            ->setUpdate($update);

        $response
            ->setTrackId($this->faker->uuid)
            ->setDate($this->faker->dateTime->format(\DateTime::ATOM))
            ->setStatus($this->faker->text(20))
            ->setAttributeGroup($attributeGroup);

        $this->response = $response;
    }

    public function testGetAndSetStatus()
    {
        $response = new Error\Response();

        $status = $this->faker->text(20);
        $response->setStatus($status);

        static::assertEquals($response->getStatus(), $status);
    }

    public function testGetAndSetTrackId()
    {
        $response = new Error\Response();

        $trackId = $this->faker->uuid;
        $response->setTrackId($trackId);

        static::assertEquals($response->getTrackId(), $trackId);
    }

    public function testGetAndSetDate()
    {
        $response = new Error\Response();

        $dateTime = $this->faker->dateTime->format(\DateTime::ATOM);
        $response->setDate($dateTime);

        static::assertEquals($response->getDate()->format(\DateTime::ATOM), $dateTime);
    }

    public function testGetAndSetAttributeGroup()
    {
        $response = new Error\Response();
        $attributeGroup = new Error\AttributeGroup();

        $response->setAttributeGroup($attributeGroup);

        static::assertEquals($response->getAttributeGroup(), $attributeGroup);
    }

    public function testXMLSerialize()
    {
        static::assertXmlStringEqualsXmlString($this->serializer->serialize($this->response, 'xml'),
            $this->getExpectedResponseContent());
    }

    /**
     * @return string
     */
    private function getExpectedResponseContent()
    {
        return <<< XML
<?xml version="1.0" encoding="utf-8"?>
<SsoResponse>
    <Status><![CDATA[{$this->response->getStatus()}]]></Status>
    <Trackid><![CDATA[{$this->response->getTrackId()}]]></Trackid>
    <Date><![CDATA[{$this->response->getDate()->format(\DateTime::ATOM)}]]></Date>
    <AttributeGroup>
        <Update>
            <Status><![CDATA[{$this->response->getAttributeGroup()->getUpdate()->getStatus()}]]></Status>
            <Errors>
                <Error>
                    <ErrorCode>
                        <![CDATA[{$this->response->getAttributeGroup()->getUpdate()->getErrors()->get(0)->getErrorCode()}]]>
                    </ErrorCode>
                    <ErrorRef>
                        <![CDATA[{$this->response->getAttributeGroup()->getUpdate()->getErrors()->get(0)->getErrorRef()}]]>
                    </ErrorRef>
                    <ShortMessage>
                        <![CDATA[{$this->response->getAttributeGroup()->getUpdate()->getErrors()->get(0)->getShortMessage()}]]>
                    </ShortMessage>
                    <LongMessage>
                        <![CDATA[{$this->response->getAttributeGroup()->getUpdate()->getErrors()->get(0)->getLongMessage()}]]>
                    </LongMessage>
                </Error>
            </Errors>
        </Update>
    </AttributeGroup>
</SsoResponse>
XML;
    }
}