<?php

/**
 * Class FactoryTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Response\UserWs\Version1\User;

use Sso\RestBundle\ModelXml\Response\UserWs\Version1\User;
use PHPUnit\Framework\TestCase;

/**
 * Class FactoryTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\RestBundle\Tests\ModelRest
 */
class FactoryTest extends TestCase
{
    /** @var User\Factory */
    private $factory;

    public function setUp()
    {
        $this->factory = new User\Factory();
    }

    public function testAddFactory()
    {
        static::assertInstanceOf(User\Add\Factory::class, $this->factory->add());
    }

    public function testDeleteFactory()
    {
        static::assertInstanceOf(User\Delete\Factory::class, $this->factory->delete());
    }
}
