<?php

/**
 * Class FactoryTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Response\UserWs\Version1\UserApplicationRole;

use Sso\RestBundle\ModelXml\Response\UserWs\Version1\UserApplicationRole;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

/**
 * Class FactoryTest
 * @package Sso\RestBundle\Tests\ModelXml\Response\UserWs\Version1\UserApplicationRole
 */
class FactoryTest extends WebTestCase
{
    /**
     * @var UserApplicationRole\Factory
     */
    private $factory;

    /**
     * {@inheritDoc}
     */
    public function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->factory = new UserApplicationRole\Factory();
    }

    public function testDelete()
    {
        static::assertInstanceOf(UserApplicationRole\Delete\Factory::class, $this->factory->delete());
    }

    public function testAdd()
    {
        static::assertInstanceOf(UserApplicationRole\Add\Factory::class, $this->factory->add());
    }
}