<?php

/**
 * Class FactoryTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Response\UserWs\Version2;

use Sso\RestBundle\ModelXml\Response\UserWs\Version2;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

/**
 * Class FactoryTest
 * @package Sso\RestBundle\Tests\ModelXml\Response\UserWs\Version2
 */
class FactoryTest extends WebTestCase
{
    /**
     * @var Version2\Factory
     */
    private $factory;

    /**
     * {@inheritDoc}
     */
    public function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->factory = new Version2\Factory();
    }

    public function testUser()
    {
        static::assertInstanceOf(Version2\User\Factory::class, $this->factory->user());
    }

    public function testUserApplication()
    {
        static::assertInstanceOf(Version2\UserApplication\Factory::class, $this->factory->userApplication());
    }

    public function testUserApplicationRole()
    {
        static::assertInstanceOf(Version2\UserApplicationRole\Factory::class, $this->factory->userApplicationRole());
    }
}