<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Response\UserWs\Version2\UserApplication;

use Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserApplication\Factory;
use Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserApplication\Show\Factory as ShowFactory;
use Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserApplication\ShowDetails\Factory as ShowDetailsFactory;
use PHPUnit\Framework\TestCase;

/**
 * Class FactoryTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\RestBundle\Tests\ModelRest
 */
class FactoryTest extends TestCase
{
    /**
     * @var Factory
     */
    private $factory;

    protected function setUp()
    {
        $this->factory = new Factory();
    }

    public function testShowFactory()
    {
        $this->assertInstanceOf(ShowFactory::class, $this->factory->show());
    }

    public function testShowDetailsFactory()
    {
        $this->assertInstanceOf(ShowDetailsFactory::class, $this->factory->showDetails());
    }
}
