<?php

/**
 * Class ResponseTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Response\UserWs\Version2\UserApplicationRole\Show\Success;

use Sso\RestBundle\Api\Manager as ApiManager;
use Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserApplicationRole\Show\Success;
use Faker\Factory as FakerFactory;
use Faker\Generator as FakerGenerator;
use JMS\Serializer\SerializerInterface;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

/**
 * Class ResponseTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\Tests\ModelRest\Response\UserWs\Version2\UserApplicationRole\Show\Error
 */
class ResponseTest extends WebTestCase
{
    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @var FakerGenerator
     */
    private $faker;

    /**
     * @var ApiManager
     */
    private $apiManager;

    /**
     * @var Success\Response
     */
    private $response;

    protected function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->apiManager = new ApiManager(static::$kernel->getContainer());
        $this->serializer = $this->apiManager->serializer();
        $this->faker = FakerFactory::create();

        $this->setUpResponse();
    }

    private function setUpResponse()
    {
        $response = new Success\Response();
        $userApplicationRole = new Success\UserApplicationRole();
        $show = new Success\Show();
        $applicationType = new Success\ApplicationType();
        $roleType = new Success\RoleType();
        $userType = new Success\UserType();

        $userType->setActive((string)$this->faker->numberBetween(0, 1))
            ->setAuthId($this->faker->numberBetween(100, 300))
            ->setCreatedAt($this->faker->dateTime)
            ->setUpdatedAt($this->faker->dateTime)
            ->setLastLoginAt($this->faker->dateTime)
            ->setLastName($this->faker->lastName)
            ->setFirstName($this->faker->firstName)
            ->setGuid($this->faker->uuid)
            ->setDeleted((string)$this->faker->numberBetween(0, 1))
            ->setEmail($this->faker->email)
            ->setUsername($this->faker->userName)
            ->setMfaEnabled((string)$this->faker->numberBetween(0, 1))
            ->setLdapSearchAttributes($this->faker->text)
            ->setLdapSearchValue($this->faker->text);

        $roleType->setName($this->faker->name)
            ->setActive((string)$this->faker->numberBetween(0, 1));

        $applicationType->setName($this->faker->name)
            ->setActive((string)$this->faker->numberBetween(0, 1))
            ->setRoleType($roleType);

        $userApplicationRole->setShow($show);
        $show->setStatus($this->faker->text)
            ->setUserType($userType)
            ->setApplicationType($applicationType);

        $response->setCode($this->faker->numberBetween(100, 300))
            ->setStatus($this->faker->text)
            ->setTrackId($this->faker->randomNumber())
            ->setDate($this->faker->dateTime)
            ->setScriptTimeSec(round($this->faker->randomFloat(), 3))
            ->setUserApplicationRole($userApplicationRole);

        $this->response = $response;
    }

    public function testGetAndSetCode()
    {
        $response = new Success\Response();
        $response->setCode(400);

        static::assertEquals($response->getCode(), 400);
    }

    public function testGetAndSetStatus()
    {
        $response = new Success\Response();
        $response->setStatus('Not Found');

        static::assertEquals($response->getStatus(), 'Not Found');
    }

    public function testGetAndSetTrackId()
    {
        $response = new Success\Response();
        $response->setTrackId('05d8386940');

        static::assertEquals($response->getTrackId(), '05d8386940');
    }

    public function testGetAndSetDate()
    {
        $response = new Success\Response();
        $dateTime = new \DateTime();
        $response->setDate($dateTime);

        static::assertEquals($response->getDate(), $dateTime);
    }

    public function testGetAndSetScriptTimeSec()
    {
        $response = new Success\Response();
        $response->setScriptTimeSec(0.413);

        static::assertEquals($response->getScriptTimeSec(), 0.413);
    }

    public function testXMLSerialize()
    {
        static::assertXmlStringEqualsXmlString($this->serializer->serialize($this->response, 'xml'),
            $this->getExpectedResponseContent());
    }

    /**
     * @return string
     */
    private function getExpectedResponseContent()
    {
        return <<< XML
<?xml version="1.0" encoding="UTF-8"?>
<SsoResponse>
    <Code>{$this->response->getCode()}</Code>
    <Status>
        <![CDATA[{$this->response->getStatus()}]]>
    </Status>
    <Trackid>
        <![CDATA[{$this->response->getTrackId()}]]>
    </Trackid>
    <Date>
        <![CDATA[{$this->response->getDate()->format(\DateTime::ATOM)}]]>
    </Date>
    <ScriptTimeSec>{$this->response->getScriptTimeSec()}</ScriptTimeSec>
    <UserApplicationRole>
        <Show>
            <Status>
                <![CDATA[{$this->response->getUserApplicationRole()->getShow()->getStatus()}]]>
            </Status>
            <UserType>
                <Guid>
                    <![CDATA[{$this->response->getUserApplicationRole()->getShow()->getUserType()->getGuid()}]]>
                </Guid>
                <Username>
                    <![CDATA[{$this->response->getUserApplicationRole()->getShow()->getUserType()->getUsername()}]]>
                </Username>
                <Email>
                    <![CDATA[{$this->response->getUserApplicationRole()->getShow()->getUserType()->getEmail()}]]>
                </Email>
                <Firstname>
                    <![CDATA[{$this->response->getUserApplicationRole()->getShow()->getUserType()->getFirstName()}]]>
                </Firstname>
                <Lastname>
                    <![CDATA[{$this->response->getUserApplicationRole()->getShow()->getUserType()->getLastName()}]]>
                </Lastname>
                <Active>{$this->response->getUserApplicationRole()->getShow()->getUserType()->getActive()}</Active>
                <Deleted>{$this->response->getUserApplicationRole()->getShow()->getUserType()->getDeleted()}</Deleted>
                <CreatedAt>
                    <![CDATA[{$this->response->getUserApplicationRole()->getShow()->getUserType()->getCreatedAt()->format(\DateTime::ATOM)}]]>
                </CreatedAt>
                <UpdatedAt>
                    <![CDATA[{$this->response->getUserApplicationRole()->getShow()->getUserType()->getUpdatedAt()->format(\DateTime::ATOM)}]]>
                </UpdatedAt>
                <LastLoginAt>
                    <![CDATA[{$this->response->getUserApplicationRole()->getShow()->getUserType()->getLastLoginAt()->format(\DateTime::ATOM)}]]>
                </LastLoginAt>
                <AuthId>
                    <![CDATA[{$this->response->getUserApplicationRole()->getShow()->getUserType()->getAuthId()}]]>
                </AuthId>
                <LdapSearchAttributes>
                    <![CDATA[{$this->response->getUserApplicationRole()->getShow()->getUserType()->getLdapSearchAttributes()}]]>
                </LdapSearchAttributes>
                <LdapSearchValue>
                    <![CDATA[{$this->response->getUserApplicationRole()->getShow()->getUserType()->getLdapSearchValue()}]]>
                </LdapSearchValue>
                <MfaEnabled>{$this->response->getUserApplicationRole()->getShow()->getUserType()->getMfaEnabled()}</MfaEnabled>
            </UserType>
            <ApplicationType>
                <Name>
                    <![CDATA[{$this->response->getUserApplicationRole()->getShow()->getApplicationType()->getName()}]]>
                </Name>
                <Active>{$this->response->getUserApplicationRole()->getShow()->getApplicationType()->getActive()}</Active>
                <RoleType>
                    <Name>
                        <![CDATA[{$this->response->getUserApplicationRole()->getShow()->getApplicationType()->getRoleType()->get(0)->getName()}]]>
                    </Name>
                    <Active>{$this->response->getUserApplicationRole()->getShow()->getApplicationType()->getRoleType()->get(0)->getActive()}</Active>
                </RoleType>
            </ApplicationType>
        </Show>
    </UserApplicationRole>
</SsoResponse>
XML;
    }
}
