<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelXml\Response\UserWs\Version2\UserSearch\FindByApplication;

use Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserSearch\FindByApplication\Factory;
use Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserSearch\FindByApplication\Success\Response as SuccessResponse;
use Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserSearch\FindByApplication\Error\Response as ErrorResponse;
use PHPUnit\Framework\TestCase;

/**
 * Class FactoryTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class FactoryTest extends TestCase
{
    /**
     * @var Factory
     */
    protected $factory;

    protected function setUp()
    {
        $this->factory = new Factory();
    }

    public function testSuccessResponse()
    {
        $this->assertInstanceOf(SuccessResponse::class, $this->factory->success());
    }

    public function testErrorResponse()
    {
        $this->assertInstanceOf(ErrorResponse::class, $this->factory->error());
    }
}
