<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Worker\MultipleWs\Version1\UserACL;

use Sso\RestBundle\Api;

/**
 * Class Factory
 * @package Sso\RestBundle\Worker\MultipleWs\Version1\UserACL
 */
class Factory
{

    /**
     * @var array
     */
    protected $facSetter;

    /*
    * @var Api\Manager
    */
    protected $apiM;

    /**
     *
     * @param Api\Manager $apiM
     */
    public function __construct(Api\Manager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     *
     * @return Validate\Handler
     */
    public function validate()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Validate\Handler($this->apiM);
        }

        return $this->facSetter[__FUNCTION__];
    }
}
