<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Worker\ObjectWs\Version1\AttributeGroup;

use Sso\RestBundle\Api;

/**
 * Class Factory
 * @package Sso\RestBundle\Worker\ObjectWs\Version1\AttributeGroup
 */
class Factory
{
    /**
     * @var array
     */
    private $facSetter;

    /**
     * @var Api\Manager
     */
    private $apiM;

    /**
     * @param Api\Manager $apiM
     */
    public function __construct(Api\Manager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @return Add\Handler
     */
    public function add()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Add\Handler($this->apiM);
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return Delete\Handler
     */
    public function delete()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Delete\Handler($this->apiM);
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return Show\Handler
     */
    public function show()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Show\Handler($this->apiM);
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return Update\Handler
     */
    public function update()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Update\Handler($this->apiM);
        }
        return $this->facSetter[__FUNCTION__];
    }
}
