<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Worker\ObjectWs\Version1;

use Sso\RestBundle\Api;

/**
 * Class Factory
 * @package Sso\RestBundle\Worker\ObjectWs\Version1
 */
class Factory
{
    /**
     * @var array
     */
    protected $facSetter;

    /**
     * @var Api\Manager
     */
    protected $apiM;

    /**
     * @param Api\Manager $apiM
     */
    public function __construct(Api\Manager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @return Object\Factory
     */
    public function object()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Object\Factory($this->apiM);
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return Language\Factory
     */
    public function language()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Language\Factory($this->apiM);
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return ObjectValue\Factory
     */
    public function objectValue()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new ObjectValue\Factory($this->apiM);
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     *
     * @return ObjectType\Factory
     */
    public function objectType()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new ObjectType\Factory($this->apiM);
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return AttributeGroup\Factory
     */
    public function attributeGroup()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new AttributeGroup\Factory($this->apiM);
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return Attribute\Factory
     */
    public function attribute()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Attribute\Factory($this->apiM);
        }
        return $this->facSetter[__FUNCTION__];
    }

}
