<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Worker\ObjectWs\Version1\ObjectType\Update\Utils;

use Sso\RestBundle\Api\Manager as ApiManager;

/**
 * Class Factory
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\Worker\ObjectWs\Version1\ObjectType\UpdateObjectType\Utils
 */
class Factory
{
    /**
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     *
     * @var array
     */
    protected $facSetter;

    /**
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     *
     * @return ObjectTypeUpdate\Index
     */
    public function objectTypeUpdate()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new ObjectTypeUpdate\Index($this->apiM);
        }
        return $this->facSetter[__FUNCTION__];
    }


}
