<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Worker\UserWs\Version1;

use Sso\RestBundle\Api;

/**
 * Class Factory
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\Worker\UserWs\Version1
 */
class Factory
{
    /**
     * @var array
     */
    protected $facSetter;

    /**
     * @var Api\Manager
     */
    protected $apiM;

    /**
     * @param Api\Manager $apiM
     */
    public function __construct(Api\Manager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @return User\Factory
     */
    public function user()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new User\Factory($this->apiM);
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return UserApplication\Factory
     */
    public function userApplication()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new UserApplication\Factory($this->apiM);
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return UserApplicationAttribute\Factory
     */
    public function userApplicationAttribute()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new UserApplicationAttribute\Factory($this->apiM);
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return UserApplicationRole\Factory
     */
    public function userApplicationRole()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new UserApplicationRole\Factory($this->apiM);
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return UserService\Factory
     */
    public function userService()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new UserService\Factory($this->apiM);
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return Application\Factory
     */
    public function application()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Application\Factory($this->apiM);
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return ApplicationAttribute\Factory
     */
    public function applicationAttribute()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new ApplicationAttribute\Factory($this->apiM);
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return ApplicationRole\Factory
     */
    public function applicationRole()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new ApplicationRole\Factory($this->apiM);
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return Attribute\Factory
     */
    public function attribute()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Attribute\Factory($this->apiM);
        }
        return $this->facSetter[__FUNCTION__];
    }
}
