<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Tools\UserIdentifierBundle\Api;

use Guzzle\Http\Exception\ClientErrorResponseException;

/**
 * Steps Controller
 *
 * @copyright  Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class Controller
{

    /**
     * Api-Manager
     *
     * @var Manager
     */
    public $apiM;

    /**
     * Constructor
     *
     * @param Manager $apiM
     */
    public function __construct(Manager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     *
     * @param string $username
     * @param string $password
     * @param string|boolean UserIdentifier on success, false otherwise
     */
    public function userIdentifierGet($username, $password)
    {
        $client = $this->apiM->client();
        $headers = array(
            'API-VERSION' => '1',
            'API-CONTROLLER' => 'UserIdentifier',
            'API-ACTION' => 'Get',
            'Content-Type' => 'text/xml; charset=UTF-8',
        );

        $request = $this->apiM->modelFactory()->request();
        $request->credentials()->serviceCountry();
        $request->userIdentifier()->get()->key()->userType()
            ->setUsername($username)
            ->setPassword($password);
        $clientRequest = $client->post($client->getBaseUrl(), $headers,
            $this->apiM->serializer()->serialize($request, 'xml'));

        try {
            $clientResponse = $clientRequest->send();
        } catch (ClientErrorResponseException $ex) {
            $this->apiM->logger()->error(sprintf('Cannot get userIdentifier! Response from "%s": %s',
                $clientRequest->getUrl(), $ex->getResponse()->getBody(true)));
            return false;
        }

        $response = $this->apiM->modelFactory()->response($clientResponse->getBody());
        try {
            return 'Success' == $response->getStatus() ? $response->getUserIdentifier()->get()->getUserType()->getUserIdentifier() : false;
        } catch (\Exception $ex) {
            $this->apiM->logger()->error(sprintf('Cannot get success userIdentifier! Response from "%s": %s',
                $clientRequest->getUrl(), $ex->getResponse()->getBody(true)));

        }
        return false;
    }

    /**
     *
     * @param string $username
     * @param string $userIdentifier
     * @return boolean
     */
    public function userIdentifierValidate($username, $userIdentifier)
    {
        $client = $this->apiM->client();
        $headers = array(
            'API-VERSION' => '1',
            'API-CONTROLLER' => 'UserIdentifier',
            'API-ACTION' => 'Validate',
            'Content-Type' => 'text/xml; charset=UTF-8',
        );
        $request = $this->apiM->modelFactory()->request();
        $request->credentials()->serviceCountry();
        $request->userIdentifier()->validate()->key()->userType()
            ->setUsername($username)
            ->setUserIdentifier($userIdentifier);
        $clientRequest = $client->post($client->getBaseUrl(), $headers,
            $this->apiM->serializer()->serialize($request, 'xml'));

        try {
            $clientResponse = $clientRequest->send();
        } catch (ClientErrorResponseException $ex) {
            $this->apiM->logger()->error(sprintf('Cannot validate userIdentifier! Response from "%s": %s',
                $clientRequest->getUrl(), $ex->getResponse()->getBody(true)));
            return false;
        }

        $response = $this->apiM->modelFactory()->response($clientResponse->getBody());
        try {
            return 'Success' == $response->getStatus() && 'Success' == $response->getUserIdentifier()->validate()->getStatus();
        } catch (\Exception $ex) {
            $this->apiM->logger()->error(sprintf('Cannot get success userIdentifier! Response from "%s": %s',
                $clientRequest->getUrl(), $ex->getResponse()->getBody(true)));

        }
        return false;
    }

}