<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Tools\UserIdentifierBundle\Model\Request\Node;

use Sso\Tools\UserIdentifierBundle\Model\Request\UserIdentifier;

/**
 * Class Factory
 * @package Sso\Tools\UserIdentifierBundle\Model\Request\Node
 */
class Factory
{
    /**
     * @return UserIdentifier
     */
    public function userIdentifier()
    {
        return new UserIdentifier($this);
    }

    /**
     * @return UserIdentifier\Get
     */
    public function userIdentifierGet()
    {
        return new UserIdentifier\Get($this);
    }

    /**
     *
     * @return UserIdentifier\Validate
     */
    public function userIdentifierValidate()
    {
        return new UserIdentifier\Validate($this);
    }

    /**
     *
     * @return Credentials
     */
    public function credentials()
    {
        return new Credentials($this);
    }

    /**
     *
     * @return Key
     */
    public function key()
    {
        return new Key($this);
    }

    /**
     *
     * @return UserType
     */
    public function userType()
    {
        return new UserType();
    }

    /**
     *
     * @return ServiceCountry
     */
    public function serviceCountry()
    {
        return new ServiceCountry();
    }

    /**
     *
     * @return ServiceProvider
     */
    public function serviceProvider()
    {
        return new ServiceProvider();
    }

    /**
     *
     * @return ServiceTrigger
     */
    public function serviceTrigger()
    {
        return new ServiceTrigger();
    }

}