<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Tools\UserIdentifierBundle\Model\Request\Node;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserType
 * @package Sso\Tools\UserIdentifierBundle\Model\Request\Node
 */
class UserType
{

    /**
     * @Serializer\SerializedName("Username")
     * @var string
     */
    private $Username;

    /**
     * @Serializer\SerializedName("Password")
     * @var string
     */
    private $Password;

    /**
     * @Serializer\SerializedName("UserIdentifier")
     * @var string
     */
    private $UserIdentifier;

    /**
     *
     * @param string $Username
     * @return UserType
     */
    public function setUsername($Username)
    {
        $this->Username = (string)$Username;

        return $this;
    }

    /**
     *
     * @return string
     */
    public function getUsername()
    {
        return $this->Username;
    }

    /**
     *
     * @param string $Password
     * @return UserType
     */
    public function setPassword($Password)
    {
        $this->Password = (string)$Password;

        return $this;
    }

    /**
     *
     * @return string
     */
    public function getPassword()
    {
        return $this->Password;
    }

    /**
     *
     * @param string $UserIdentifier
     * @return UserType
     */
    public function setUserIdentifier($UserIdentifier)
    {
        $this->UserIdentifier = (string)$UserIdentifier;

        return $this;
    }

    /**
     *
     * @return string
     */
    public function getUserIdentifier()
    {
        return $this->UserIdentifier;
    }
}