<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\CachingBundle\Annotations;

use Doctrine\Common\Annotations\Annotation;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ConfigurationAnnotation;

/**
 * @Annotation
 * @package LifeStyle\Tools\CachingBundle\Annotations
 */
class LsCache extends ConfigurationAnnotation
{
    /**
     * @var null|integer
     */
    private $cacheTTL = null;

    /**
     * @var boolean
     */
    private $keyHeader;

    /**
     * @param int $cacheTTL
     * @return LsCache
     */
    public function setCacheTTL($cacheTTL)
    {
        $this->cacheTTL = (int)$cacheTTL;
        return $this;
    }

    /**
     * @param boolean $keyHeader
     * @return LsCache
     */
    public function setKeyHeader($keyHeader)
    {
        $this->keyHeader = $keyHeader;
        return $this;
    }

    /**
     * @return int
     */
    public function getCacheTTL()
    {
        return $this->cacheTTL;
    }

    /**
     * @return boolean
     */
    public function isKeyHeader()
    {
        return $this->keyHeader;
    }

    /**
     * @return string
     * @see ConfigurationInterface
     */
    public function getAliasName()
    {
        return 'lsCache';
    }

    /**
     * @return bool
     * @see ConfigurationInterface
     */
    public function allowArray()
    {
        return false;
    }
}
