<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\CachingBundle\Api\Data;

use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use LifeStyle\Tools\CachingBundle\Api\Manager as ApiManager;

/**
 * Class Factory
 * @package LifeStyle\Tools\CachingBundle\Api\Data
 */
class Factory
{
    /**
     * @var array
     */
    private $setter;

    /**
     * @var ApiManager
     */
    private $apiM;

    /**
     * Factory constructor.
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @return Reader\ReaderInterface
     */
    public function reader()
    {
        if (!isset($this->setter[__FUNCTION__])) {
            $readerClass = __NAMESPACE__ . '\\Reader\\' . ucfirst($this->apiM->getConfig()->getCachingEngine()) . '\\Reader';
            $this->setter[__FUNCTION__] = new $readerClass($this->apiM);
        }

        return $this->setter[__FUNCTION__];
    }

    /**
     * @return Reader\ReaderResponse
     */
    public function readerResponse()
    {
        if (!isset($this->setter[__FUNCTION__])) {
            $this->setter[__FUNCTION__] = new Reader\ReaderResponse();
        }

        return $this->setter[__FUNCTION__];
    }

    /**
     * @return Writer\WriterInterface
     */
    public function writer()
    {
        if (!isset($this->setter[__FUNCTION__])) {
            $writerClass = __NAMESPACE__ . '\\Writer\\' . ucfirst($this->apiM->getConfig()->getCachingEngine()) . '\\Writer';
            $this->setter[__FUNCTION__] = new $writerClass($this->apiM);
        }

        return $this->setter[__FUNCTION__];
    }

    /**
     * @return Common\Factory
     */
    public function common()
    {
        if (!isset($this->setter[__FUNCTION__])) {
            $this->setter[__FUNCTION__] = new Common\Factory($this->apiM);
        }

        return $this->setter[__FUNCTION__];
    }
}
