<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\CachingBundle\Api\Data\Reader;

use Symfony\Component\HttpFoundation\Request as HttpRequest;

/**
 * Class ReaderResponse
 * @package LifeStyle\Tools\CachingBundle\Api\Data\Reader
 */
final class ReaderResponse
{
    /**
     * @var HttpRequest
     */
    private $request;

    /**
     * @var string|null
     */
    private $cacheKey;

    /**
     * @var bool
     */
    private $buildCache;

    /**
     * @var integer
     */
    private $cacheTTL;

    /**
     * @return HttpRequest
     */
    public function getRequest()
    {
        return $this->request;
    }

    /**
     * @param HttpRequest $request
     * @return ReaderResponse
     */
    public function setRequest($request)
    {
        $this->request = $request;
        return $this;
    }

    /**
     * @return null|string
     */
    public function getCacheKey()
    {
        return $this->cacheKey;
    }

    /**
     * @param null|string $cacheKey
     * @return ReaderResponse
     */
    public function setCacheKey($cacheKey)
    {
        $this->cacheKey = $cacheKey;
        return $this;
    }

    /**
     * @return boolean
     */
    public function isBuildCache()
    {
        return $this->buildCache;
    }

    /**
     * @param boolean $buildCache
     * @return ReaderResponse
     */
    public function setBuildCache($buildCache)
    {
        $this->buildCache = $buildCache;
        return $this;
    }

    /**
     * @return int
     */
    public function getCacheTTL()
    {
        return $this->cacheTTL;
    }

    /**
     * @param int $cacheTTL
     * @return ReaderResponse
     */
    public function setCacheTTL($cacheTTL)
    {
        $this->cacheTTL = $cacheTTL;
        return $this;
    }
}
