<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\CachingBundle\Api;

use Symfony\Component\DependencyInjection\ContainerInterface as Container;
use \LifeStyle\Tools\CachingBundle\Annotations\Factory as AnnotationsFactory;

/**
 * Class Manager
 * @package Sso\WebserviceBundle\Security\Api
 */
class Manager
{
    /**
     * @var array
     */
    private $setter;

    /**
     * @var Container
     */
    private $container;

    /**
     * @var Configuration\Configuration
     */
    private $config;

    /**
     * Manager constructor.
     * @param Container $container
     * @param array $config
     */
    public function __construct(Container $container, $config)
    {
        $this->container = $container;
        $this->config = new Configuration\Configuration($config);
    }

    /**
     * @return float
     */
    public function scriptTimeSeconds()
    {
        return $this->container->get('rest_performance_listener')->getScriptSeconds();
    }

    /**
     * @return Configuration\Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * @return Data\Factory
     */
    public function data()
    {
        if (!isset($this->setter[__FUNCTION__])) {
            $this->setter[__FUNCTION__] = new Data\Factory($this);
        }
        return $this->setter[__FUNCTION__];
    }

    /**
     * Returns an instance of the memcache extension object, or NULL when no memcache extension is available
     *
     * @return \Memcache|\Memcached|null
     */
    public function getMemcache()
    {
        if (!isset($this->setter[__FUNCTION__])) {
            $memcache = null;

            // we have to be a bit careful here, as there are two different memcache extensions for PHP
            // unfortunately they also differ heavily in functionality
            if (extension_loaded('memcache')) {
                $memcache = new \Memcache();
            } elseif (extension_loaded('memcached')) {
                $memcache = new \Memcached();
            }

            // set base config
            if (null !== $memcache) {
                $memcache->addServer($this->config->getMemcacheHost(), $this->config->getMemcachePort());
            }

            $this->setter[__FUNCTION__] = $memcache;
        }
        return $this->setter[__FUNCTION__];
    }

    /**
     * Returns the name of the available memcache extension ('memcache' or 'memcached').
     * Empty string if no memcache extension is available.
     *
     * @return string
     */
    public function getMemcacheExtName()
    {
        $memcache = '';

        if (extension_loaded('memcache')) {
            $memcache = 'memcache';
        } elseif (extension_loaded('memcached')) {
            $memcache = 'memcached';
        }

        return $memcache;
    }

    /**
     * @return AnnotationsFactory
     */
    public function annotations()
    {
        if (!isset($this->setter[__FUNCTION__])) {
            $this->setter[__FUNCTION__] = new AnnotationsFactory($this);
        }
        return $this->setter[__FUNCTION__];
    }
}
