<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\CachingBundle\EventDispatcher;

use LifeStyle\Tools\CachingBundle\EventDispatcher\Event\CachedResponse;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Symfony\Component\HttpFoundation\Request;

/**
 * Class Manager
 * @package LifeStyle\Tools\CachingBundle\EventDispatcher
 */
class Manager
{
    /**
     * @var EventDispatcherInterface
     */
    private $dispatcher;

    /**
     * Manager constructor.
     * @param EventDispatcherInterface $dispatcher
     */
    public function __construct(EventDispatcherInterface $dispatcher)
    {
        $this->dispatcher = $dispatcher;
    }

    /**
     * @param Request $request
     * @return CachedResponse
     */
    public function dispatchCachedResponseEvent($request)
    {
        $event = new CachedResponse($request);
        return $this->dispatcher->dispatch(Events::CACHE_CACHED_RESPONSE, $event);
    }
}
