<?php

/**
 * Class FactoryTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\CachingBundle\Tests\Api\Data;

use LifeStyle\Tools\CachingBundle\Api\Manager as ApiManager;
use LifeStyle\Tools\CachingBundle\Api\Configuration\Configuration;
use LifeStyle\Tools\CachingBundle\Api\Data\Reader\Apc\Reader as CacheReaderApc;
use LifeStyle\Tools\CachingBundle\Api\Data\Reader\Memcache\Reader as CacheReaderMemcache;
use LifeStyle\Tools\CachingBundle\Api\Data\Writer\Apc\Writer as CacheWriterApc;
use LifeStyle\Tools\CachingBundle\Api\Data\Writer\Memcache\Writer as CacheWriterMemcache;
use LifeStyle\Tools\CachingBundle\Api\Data\Factory as DataFactory;
use PHPUnit_Framework_TestCase;

/**
 * Class FactoryTest
 * @package LifeStyle\Tools\CachingBundle\Tests\Api\Data
 */
class FactoryTest extends PHPUnit_Framework_TestCase
{
    public function testGettingReaderApc()
    {
        $configData = [
            'cache_enabled' => true,
            'caching_engine' => 'apc',
            'default_ttl' => 42,
            'memcache_host' => '127.0.0.1',
            'memcache_port' => '11211',
        ];
        $config = new Configuration($configData);

        $apiManagerMock = $this->getMockBuilder(ApiManager::class)
            ->disableOriginalConstructor()
            ->setMethods([
                'getConfig',
                'getMemcache',
                'getMemcacheExtName'
            ])
            ->getMock();
        $apiManagerMock->expects($this->any())
            ->method('getConfig')
            ->will($this->returnValue($config));
        $apiManagerMock->expects($this->any())
            ->method('getMemcache')
            ->will($this->returnValue(null));
        $apiManagerMock->expects($this->any())
            ->method('getMemcacheExtName')
            ->will($this->returnValue('memcache'));


        $factory = new DataFactory($apiManagerMock);
        $this->assertInstanceOf(CacheReaderApc::class, $factory->reader());
    }

    public function testGettingReaderMemcache()
    {
        $configData = [
            'cache_enabled' => true,
            'caching_engine' => 'memcache',
            'default_ttl' => 42,
            'memcache_host' => '127.0.0.1',
            'memcache_port' => '11211',
        ];
        $config = new Configuration($configData);

        $apiManagerMock = $this->getMockBuilder(ApiManager::class)
            ->disableOriginalConstructor()
            ->setMethods([
                'getConfig',
                'getMemcache',
                'getMemcacheExtName'
            ])
            ->getMock();
        $apiManagerMock->expects($this->any())
            ->method('getConfig')
            ->will($this->returnValue($config));
        $apiManagerMock->expects($this->any())
            ->method('getMemcache')
            ->will($this->returnValue(null));
        $apiManagerMock->expects($this->any())
            ->method('getMemcacheExtName')
            ->will($this->returnValue('memcache'));


        $factory = new DataFactory($apiManagerMock);
        $this->assertInstanceOf(CacheReaderMemcache::class, $factory->reader());
    }

    public function testGettingWriterApc()
    {
        $configData = [
            'cache_enabled' => true,
            'caching_engine' => 'apc',
            'default_ttl' => 42,
            'memcache_host' => '127.0.0.1',
            'memcache_port' => '11211',
        ];
        $config = new Configuration($configData);

        $apiManagerMock = $this->getMockBuilder(ApiManager::class)
            ->disableOriginalConstructor()
            ->setMethods([
                'getConfig',
                'getMemcache',
                'getMemcacheExtName'
            ])
            ->getMock();
        $apiManagerMock->expects($this->any())
            ->method('getConfig')
            ->will($this->returnValue($config));
        $apiManagerMock->expects($this->any())
            ->method('getMemcache')
            ->will($this->returnValue(null));
        $apiManagerMock->expects($this->any())
            ->method('getMemcacheExtName')
            ->will($this->returnValue('memcache'));


        $factory = new DataFactory($apiManagerMock);
        $this->assertInstanceOf(CacheWriterApc::class, $factory->writer());
    }

    public function testGettingWriterMemcache()
    {
        $configData = [
            'cache_enabled' => true,
            'caching_engine' => 'memcache',
            'default_ttl' => 42,
            'memcache_host' => '127.0.0.1',
            'memcache_port' => '11211',
        ];
        $config = new Configuration($configData);

        $apiManagerMock = $this->getMockBuilder(ApiManager::class)
            ->disableOriginalConstructor()
            ->setMethods([
                'getConfig',
                'getMemcache',
                'getMemcacheExtName'
            ])
            ->getMock();
        $apiManagerMock->expects($this->any())
            ->method('getConfig')
            ->will($this->returnValue($config));
        $apiManagerMock->expects($this->any())
            ->method('getMemcache')
            ->will($this->returnValue(null));
        $apiManagerMock->expects($this->any())
            ->method('getMemcacheExtName')
            ->will($this->returnValue('memcache'));


        $factory = new DataFactory($apiManagerMock);
        $this->assertInstanceOf(CacheWriterMemcache::class, $factory->writer());
    }
}
