<?php

/**
 * Class ReaderResponse
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\CachingBundle\Tests\Api\Data\Reader;

use Symfony\Component\HttpFoundation\Request;
use LifeStyle\Tools\CachingBundle\Api\Data\Reader\ReaderResponse;
use PHPUnit_Framework_TestCase;

/**
 * Class ReaderResponse
 * @package LifeStyle\Tools\CachingBundle\Tests\Api\Data\Reader
 */
class ReaderResponseTest extends PHPUnit_Framework_TestCase
{
    public function testReponseObject()
    {
        $readerResponse = new ReaderResponse();

        $request = new Request();
        $request->attributes->set('test', 'toast');

        $readerResponse->setRequest($request);
        $readerResponse->setBuildCache(true);
        $readerResponse->setCacheKey('moop');
        $readerResponse->setCacheTTL(42);

        $this->assertEquals('toast', $readerResponse->getRequest()->attributes->get('test'));
        $this->assertEquals(true, $readerResponse->isBuildCache());
        $this->assertEquals('moop', $readerResponse->getCacheKey());
        $this->assertEquals(42, $readerResponse->getCacheTTL());
    }
}
