<?php

/**
 * Class WriterTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\CachingBundle\Tests\Api\Data\Writer\Memcache;

use Symfony\Component\HttpFoundation\Response;
use LifeStyle\Tools\CachingBundle\Api\Manager as ApiManager;
use LifeStyle\Tools\CachingBundle\Api\Configuration\Configuration;
use LifeStyle\Tools\CachingBundle\Api\Data\Writer\Memcache\Writer as CacheWriter;
use PHPUnit_Framework_TestCase;

/**
 * Class WriterTest
 * @package LifeStyle\Tools\CachingBundle\Tests\Api\Data\Writer\Memcache
 */
class WriterTest extends PHPUnit_Framework_TestCase
{
    public function testCacheWriterMemcache()
    {
        $configData = [
            'cache_enabled' => true,
            'caching_engine' => 'memcache',
            'default_ttl' => 42,
            'memcache_host' => '127.0.0.1',
            'memcache_port' => '11211',
        ];
        $config = new Configuration($configData);

        $memcacheMock = $this->getMockBuilder(\Memcache::class)
            ->disableOriginalConstructor()
            ->setMethods([
                'set'
            ])
            ->getMock();

        // assert value - for the test to be successfull memcache::set needs to be called 2 times
        // (once for the content + once for the status value)
        $memcacheMock->expects($this->exactly(2))
            ->method('set');

        $apiManagerMock = $this->getMockBuilder(ApiManager::class)
            ->disableOriginalConstructor()
            ->setMethods([
                'getConfig',
                'getMemcache',
                'getMemcacheExtName',
                'scriptTimeSeconds'
            ])
            ->getMock();
        $apiManagerMock->expects($this->any())
            ->method('getConfig')
            ->will($this->returnValue($config));
        $apiManagerMock->expects($this->any())
            ->method('getMemcache')
            ->will($this->returnValue($memcacheMock));
        $apiManagerMock->expects($this->any())
            ->method('getMemcacheExtName')
            ->will($this->returnValue('memcache'));
        $apiManagerMock->expects($this->any())
            ->method('scriptTimeSeconds')
            ->will($this->returnValue(0.0));

        $response = new Response();
        $response->setContent('content');

        $cacheWriter = new CacheWriter($apiManagerMock);
        // assert: in the memcache mock we defined "memcache::set()" needs to be called twice
        $cacheWriter->writeCache($response, 'cacheKey', 42);
    }

    public function testCacheWriterMemcached()
    {
        $configData = [
            'cache_enabled' => true,
            'caching_engine' => 'memcache',
            'default_ttl' => 42,
            'memcache_host' => '127.0.0.1',
            'memcache_port' => '11211',
        ];
        $config = new Configuration($configData);

        $memcacheMock = $this->getMockBuilder(\Memcache::class)
            ->disableOriginalConstructor()
            ->setMethods([
                'set'
            ])
            ->getMock();

        // assert value - for the test to be successfull memcache::set needs to be called 2 times
        // (once for the content + once for the status value)
        $memcacheMock->expects($this->exactly(2))
            ->method('set');

        $apiManagerMock = $this->getMockBuilder(ApiManager::class)
            ->disableOriginalConstructor()
            ->setMethods([
                'getConfig',
                'getMemcache',
                'getMemcacheExtName',
                'scriptTimeSeconds'
            ])
            ->getMock();
        $apiManagerMock->expects($this->any())
            ->method('getConfig')
            ->will($this->returnValue($config));
        $apiManagerMock->expects($this->any())
            ->method('getMemcache')
            ->will($this->returnValue($memcacheMock));
        $apiManagerMock->expects($this->any())
            ->method('getMemcacheExtName')
            ->will($this->returnValue('memcached'));
        $apiManagerMock->expects($this->any())
            ->method('scriptTimeSeconds')
            ->will($this->returnValue(0.0));

        $response = new Response();
        $response->setContent('content');

        $cacheWriter = new CacheWriter($apiManagerMock);
        // assert: in the memcache mock we defined "memcache::set()" needs to be called twice
        $cacheWriter->writeCache($response, 'cacheKey', 42);
    }
}
