<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\DbLogBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\Form\FormError;

/**
 * Class LogFilterType
 * @package LifeStyle\Tools\DbLogBundle\Form
 */
class LogFilterType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('level', 'filter_number')
            ->add('channel', 'filter_text')
            ->add('extras', 'filter_text', array('label' => 'Extras'));

        $listener = function (FormEvent $event) {

            // Is data empty?
            if ($this->isEmpty($event->getData())) {
                $event->getForm()->addError(new FormError('Filter empty'));
            }
        };
        $builder->addEventListener(FormEvents::POST_SUBMIT, $listener);
    }

    /**
     * @param mixed $data
     * @return boolean
     */
    private function isEmpty($data)
    {
        if (is_array($data)) {
            foreach ($data as $value) {
                if (!$this->isEmpty($value)) {
                    return false;
                }
            }
            return true;
        }
        return empty($data);
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'sso_backendbundle_dblog';
    }
}
