<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\ElkLogFormatterBundle\Tests\Monolog\Processor;

use LifeStyle\Tools\ElkLogFormatterBundle\Tests\Monolog\TestCase;
use LifeStyle\Tools\ElkLogFormatterBundle\Monolog\Processor;

/**
 * Class TrackIdTest
 * @package LifeStyle\Tools\ElkLogFormatterBundle\Tests\Monolog\Processor
 */
class TrackIdTest extends TestCase
{
    public function testProcessorWithTrackId()
    {

        $processor = new Processor\TrackId('4711');
        $record = $processor($this->getRecord());

        $this->assertEquals('4711', $record['extra']['token']);
    }

    public function testProcessorWithGeneratedTrackId()
    {
        $processor = new Processor\TrackId();
        $record = $processor($this->getRecord());

        $this->assertEquals(10, strlen($record['extra']['token']));
    }

    public function testProcessorWithTrackIdFalse()
    {
        $processor = new Processor\TrackId();
        $record = $processor($this->getRecord());

        $this->assertNotEquals('4711', $record['extra']['token']);
    }

    public function testProcessorWithGeneratedTrackIdFalse()
    {
        $processor = new Processor\TrackId('4711');
        $record = $processor($this->getRecord());

        $this->assertNotEquals(10, strlen($record['extra']['token']));
    }
}
