<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\RestAuthBundle\Model\Request\Node;

use JMS\Serializer\Annotation as Serializer;

/**
 * Steps ServiceProvider
 *
 * @copyright  Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class ServiceProvider
{
    /**
     * @Serializer\SerializedName("ServiceToken")
     * @var string
     */
    private $serviceToken;

    /**
     * @Serializer\SerializedName("ServiceName")
     * @var string
     */
    private $serviceName;

    /**
     * @param string $serviceToken
     * @return ServiceProvider
     */
    public function setServiceToken($serviceToken)
    {
        $this->serviceToken = (string)$serviceToken;

        return $this;
    }

    /**
     * @return string
     */
    public function getServiceToken()
    {
        return $this->serviceToken;
    }

    /**
     * @param string $serviceName
     * @return ServiceProvider
     */
    public function setServiceName($serviceName)
    {
        $this->serviceName = (string)$serviceName;

        return $this;
    }

    /**
     * @return string
     */
    public function getServiceName()
    {
        return $this->serviceName;
    }
}
