<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\RestAuthBundle\Model;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Response
 * @package LifeStyle\Tools\RestAuthBundle\Model
 */
class Response
{
    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("Trackid")
     * @Serializer\Type("string")
     * @var string
     */
    private $trackid;

    /**
     * @Serializer\SerializedName("Date")
     * @Serializer\Type("string")
     * @var string
     */
    private $date;

    /**
     * @Serializer\SerializedName("UserIdentifier")
     * @Serializer\Type("LifeStyle\Tools\RestAuthBundle\Model\Response\UserIdentifier")
     * @var Response\UserIdentifier
     */
    private $userIdentifier;

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @return string
     */
    public function getTrackId()
    {
        return $this->trackid;
    }

    /**
     * @return string
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * @return Response\UserIdentifier
     */
    public function getUserIdentifier()
    {
        return $this->userIdentifier;
    }
}
