<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\RestAuthBundle\Security\Authentication\Provider;

use Symfony\Component\DependencyInjection\ContainerInterface as Container;
use Symfony\Component\Security\Core\Authentication\Provider\AuthenticationProviderInterface;
use Symfony\Component\Security\Core\User\UserProviderInterface;
use Symfony\Component\Security\Core\Exception\AuthenticationException;
use Symfony\Component\Security\Core\Exception\NonceExpiredException;
use Symfony\Component\Security\Core\Authentication\Token\TokenInterface;
use LifeStyle\Tools\RestAuthBundle\Security\Authentication\Token\UidentifyToken;
use Symfony\Component\Security\Core\Util\StringUtils;
use LifeStyle\Tools\RestAuthBundle\Api;

/**
 * Class UidentifyProvider
 * @package LifeStyle\Tools\RestAuthBundle\Security\Authentication\Provider
 */
class UidentifyProvider implements AuthenticationProviderInterface
{
    /**
     * @var Container
     */
    private $container;

    /**
     * @var UserProviderInterface
     */
    private $userProvider;

    /**
     * @var Api\Manager
     */
    protected $apiM;

    /**
     * @param UserProviderInterface $userProvider
     */
    public function __construct(UserProviderInterface $userProvider, Container $container)
    {
        $this->userProvider = $userProvider;
        $this->container = $container;
        $this->apiM = $this->container->get('uidentify_api_manager');
    }

    /**
     * @param TokenInterface $token
     * @return UidentifyToken
     * @throws AuthenticationException
     */
    public function authenticate(TokenInterface $token)
    {
        if ($this->validateUserIdentifier($token)) {

            $authenticatedToken = new UidentifyToken(['ROLE_API']);
            $authenticatedToken->setUser($token->getUser());
            $authenticatedToken->useridentifier = $token->useridentifier;
            $authenticatedToken->servicetoken = $token->servicetoken;
            $authenticatedToken->username = $token->username;

            return $authenticatedToken;
        }

        throw new AuthenticationException('uidentifier not valid', 2);
    }

    /**
     * @param TokenInterface $token
     * @return boolean
     */
    protected function validateUserIdentifier(TokenInterface $token)
    {
        return $this->apiM->controller()->userIdentifierValidate($token->username, $token->useridentifier);
    }

    /**
     * @param TokenInterface $token
     * @return boolean
     */
    public function supports(TokenInterface $token)
    {
        return $token instanceof UidentifyToken;
    }

}
