<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\RestErrorBundle\Api\Error\Errors\Entity;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Error
 * @package LifeStyle\Tools\RestErrorBundle\Api\Error\Errors\Entity
 * @Serializer\ExclusionPolicy("all")
 */
class Error
{
    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("code")
     * @Serializer\Type("integer")
     * @var integer
     */
    private $code;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("status")
     * @Serializer\Type("string")
     * @var string
     */
    private $status;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("message")
     * @Serializer\Type("string")
     * @var string
     */
    private $message;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("type")
     * @Serializer\Type("string")
     * @var string
     */
    private $type;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("exception")
     * @Serializer\Type("string")
     * @var string
     */
    private $exception;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("debug")
     * @Serializer\Type("string")
     * @var string
     */
    private $debug;

    /**
     * @var array
     */
    private $statusMessages;

    /**
     * Error constructor.
     */
    public function __construct()
    {
        $this->statusMessages = [
            200 => 'OK',
            204 => 'No Content',
            400 => 'Bad Request',
            401 => 'Unauthorized',
            416 => 'Range Not Satisfiable',
            500 => 'Internal Server Error',
        ];
    }

    /**
     * @param $code
     * @return $this
     */
    public function setCode($code)
    {
        $this->code = (int)$code;
        if (isset($this->statusMessages[$code])) {
            $this->status = $this->statusMessages[$code];
        } else {
            $this->status = 'Not Found';
        }
        return $this;
    }

    /**
     * Get code
     *
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param string $message
     * @return $this
     */
    public function setMessage($message)
    {
        $this->message = (string)$message;

        return $this;
    }

    /**
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * @param string $type
     * @return $this
     */
    public function setType($type)
    {
        $this->type = (string)$type;

        return $this;
    }

    /**
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @param string $debug
     * @return $this
     */
    public function setDebug($debug)
    {
        $this->debug = (string)$debug;

        return $this;
    }

    /**
     * @return string
     */
    public function getDebug()
    {
        return $this->debug;
    }

    /**
     * @param string $exception
     */
    public function setException($exception)
    {
        $this->exception = (string)$exception;
    }

    /**
     * @return string
     */
    public function getException()
    {
        return $this->exception;
    }
}
