<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\RestErrorBundle\Api\Error\Helper;

/**
 * Class Index
 * @package LifeStyle\Tools\RestErrorBundle\Api\Error\Helper
 */
class Index
{
    /**
     * @param mixed $class
     * @return string
     */
    public function getClassNameFromObject($class)
    {
        try {
            $classname = get_class($class);
        } catch (\Exception $exc) {
            return $class;
        }
        if ($pos = strrpos($classname, '\\')) {
            $class = substr($classname, $pos + 1);
        }

        return $class;
    }
}
