<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Api\Configuration\ScopeConfig;

use Symfony\Component\DependencyInjection\ContainerInterface as Container;

/**
 * Class Index
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\Api\Configuration\ScopeConfig
 */
class Index
{

    /**
     * @var Container
     */
    protected $container;

    /**
     * @var array
     */
    protected $scopeConfig;

    /**
     * @param Container $container
     */
    public function __construct(Container $container)
    {
        $this->container = $container;
        $tempArray = $this->container->getParameter('sso_rest');
        $this->scopeConfig = $tempArray['scope_config'];
    }

    /**
     * @return string
     */
    public function getScopeApplicationName()
    {
        return $this->scopeConfig['scope_application_name'];
    }

    /**
     * @return array
     */
    public function getScopeAttributes()
    {
        return $this->scopeConfig['scope_attributes'];
    }
}
