<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Api\Helper;

/**
 * Class Factory
 * @package Sso\RestBundle\Api\Helper
 */
class Factory
{
    const STRING = 'string';
    const MAPPER = 'mapper';

    /**
     * @var array
     */
    protected $facSetter;

    /**
     * @return String\Index
     */
    public function string()
    {
        if (!isset($this->facSetter[static::STRING])) {
            $this->facSetter[static::STRING] = new String\Index();
        }
        return $this->facSetter[static::STRING];
    }

    /**
     * @return Mapper\Index
     */
    public function mapper()
    {
        if (!isset($this->facSetter[static::MAPPER])) {
            $this->facSetter[static::MAPPER] = new Mapper\Index();
        }
        return $this->facSetter[static::MAPPER];
    }
}
