<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use Symfony\Bridge\Monolog\Logger;
use Symfony\Component\DependencyInjection\ContainerInterface as Container;
use LifeStyle\Tools\RestErrorBundle\Api\Manager as ErrorManager;
use Sso\RestBundle\Api\Client\Helper\Factory as ClientHelper;
use Sso\RestBundle\ModelRest\Factory as ModelRestFactory;
use Sso\RestBundle\ModelXml\Factory as ModelXmlFactory;
use Sso\RestBundle\Worker\Worker as Worker;
use LifeStyle\Tools\RestAuthBundle\Security\Authentication\Token\UidentifyToken;
use FOS\RestBundle\View\View as RestView;
use JMS\Serializer\Naming\IdenticalPropertyNamingStrategy;
use JMS\Serializer\SerializerBuilder;

/**
 * Class Manager
 * @package Sso\RestBundle\Api
 */
class Manager
{
    /**
     * @var array
     */
    protected $setter;

    /**
     * @var Container
     */
    protected $container;

    /**
     * Manager constructor.
     * @param Container $container
     */
    public function __construct(Container $container)
    {
        $this->container = $container;
    }

    /**
     * @return Worker
     */
    public function worker()
    {
        if (!isset($this->setter[__FUNCTION__])) {
            $this->setter[__FUNCTION__] = new Worker($this);
        }

        return $this->setter[__FUNCTION__];
    }

    /**
     * @return Logger
     */
    public function logger()
    {
        return $this->container->get('logger');
    }

    /**
     * @return \JMS\Serializer\Serializer
     */
    public function serializer($identicalPropertyNaming = false)
    {
        if ($identicalPropertyNaming) {
            return SerializerBuilder::create()
                ->setPropertyNamingStrategy(new IdenticalPropertyNamingStrategy())
                ->build();
        } else {
            return $this->container->get('jms_serializer');
        }
    }

    /**
     * @return ErrorManager
     */
    public function errorManager()
    {
        return $this->container->get('rest_error_api_manager');
    }

    /**
     * @return ModelRestFactory
     */
    public function modelRest()
    {
        if (!isset($this->setter[__FUNCTION__])) {
            $this->setter[__FUNCTION__] = new ModelRestFactory();
        }

        return $this->setter[__FUNCTION__];
    }

    /**
     * @return ModelXmlFactory
     */
    public function modelXml()
    {
        if (!isset($this->setter[__FUNCTION__])) {
            $this->setter[__FUNCTION__] = new ModelXmlFactory();
        }

        return $this->setter[__FUNCTION__];
    }

    /**
     * @return \Symfony\Component\Validator\Validator\ValidatorInterface
     */
    public function validator()
    {
        return $this->container->get('validator');
    }

    /**
     * @return Client
     */
    public function client()
    {
        if (!isset($this->setter[__FUNCTION__])) {
            $this->setter[__FUNCTION__] = new Client();
        }

        return $this->setter[__FUNCTION__];
    }

    /**
     * @return ClientHelper
     */
    public function clientHelper()
    {
        if (!isset($this->setter[__FUNCTION__])) {
            $this->setter[__FUNCTION__] = new ClientHelper();
        }
        return $this->setter[__FUNCTION__];
    }

    /**
     * @param ClientInterface $client
     * @return $this
     */
    public function setClient(ClientInterface $client)
    {
        $this->setter['client'] = $client;

        return $this;
    }

    /**
     * @return Configuration\Factory
     */
    public function configuration()
    {
        if (!isset($this->setter[__FUNCTION__])) {
            $this->setter[__FUNCTION__] = new Configuration\Factory($this->container);
        }

        return $this->setter[__FUNCTION__];
    }

    /**
     * @return Helper\Factory
     */
    public function helper()
    {
        if (!isset($this->setter[__FUNCTION__])) {
            $this->setter[__FUNCTION__] = new Helper\Factory();
        }

        return $this->setter[__FUNCTION__];
    }

    /**
     * @return Container
     */
    public function getContainer()
    {
        if (!isset($this->setter[__FUNCTION__])) {
            $this->setter[__FUNCTION__] = $this->container;
        }

        return $this->setter[__FUNCTION__];
    }

    /**
     * @return float
     */
    public function scriptTimeSeconds()
    {
        return $this->container->get('rest_performance_listener')->getScriptSeconds();
    }

    /**
     * @return UidentifyToken
     */
    public function getToken()
    {
        return $this->container->get('security.token_storage')->getToken();
    }

    /**
     * @return string
     */
    public function trackId()
    {
        return $this->container->get('lifestyle.elk.monolog.processor.trackid')->getTrackId();
    }

    /**
     * @return MainValidator\Index
     */
    public function mainValidator()
    {
        if (!isset($this->setter[__FUNCTION__])) {
            $this->setter[__FUNCTION__] = new MainValidator\Index($this->errorManager(), $this->helper());
        }

        return $this->setter[__FUNCTION__];
    }

    /**
     * @return RestView
     */
    public function restView()
    {
        return RestView::create();
    }
}
