<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Controller;

use FOS\RestBundle\Controller\FOSRestController;
use Sso\RestBundle\Api;
use JMS\DiExtraBundle\Annotation as DI;

/**
 * Class AbstractController
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\Controller
 */
abstract class AbstractController extends FOSRestController
{
    /**
     * @DI\Inject("rest_api_manager")
     * @var Api\Manager
     */
    public $apiM;

    /**
     * @return Api\Manager
     */
    public function apiM()
    {
        return $this->apiM;
    }
}
