<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Controller;

use FOS\RestBundle\Controller\Annotations\RequestParam;
use FOS\RestBundle\Controller\Annotations\QueryParam;
use FOS\RestBundle\View\View;
use FOS\RestBundle\Request\ParamFetcher;
use JMS\SecurityExtraBundle\Annotation\Secure;
use Symfony\Component\Validator\ConstraintViolationList;
use Nelmio\ApiDocBundle\Annotation\ApiDoc;
use LifeStyle\Tools\RestAuthBundle\Security\Authentication\Token\UidentifyToken;
use FOS\RestBundle\Controller\Annotations\NamePrefix;
use Sso\RestBundle\Api;
use Symfony\Component\HttpFoundation\Request;

/**
 * Class ApplicationController
 *
 * @NamePrefix("api_rest_")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\Controller
 */
class ApplicationController extends AbstractController
{
    /**
     * @var array
     */
    protected $apiSetter;

    /**
     * @var UidentifyToken
     */
    protected $userToken;

    /**
     *
     * *This service deletes single or multiple applications from the user-webservice by its name.
     * The service expects a JSON or XML in body, and a header authentication.*
     *
     * #Request (header)
     *
     *      Key                 | Value               | Description
     *      ------------------- | ------------------- | --------------------------------------
     *      username            |  (string)           | your username
     *      useridentifier      |  (string)           | your useridentifier for given username
     *      servicetoken        |  (string)           | servicetoken from ws
     *
     * #Request (body)
     *
     *
     * **Request Example JSON**
     *
     *
     * **Request Example XML**
     *
     *
     *
     *
     * #Response success
     *
     * **Example (header)**
     *
     *     200 OK
     *
     *
     * **Example JSON (body)**
     *
     *
     * **Example XML (body)**
     *
     *
     *
     * #Response error
     *
     * **Example JSON (body)**
     *
     *
     * **Example XML (body)**
     *
     *
     *
     * @ApiDoc(
     *  resource=true,
     *  description="secured: Deletes applications from sso-user-ws",
     *  statusCodes={
     *         200="Returned when successful",
     *         204="Returned when no content was send",
     *         400="Returned when an error occured",
     *         401="Unauthorized - Wrong credentials",
     *         403="Returned when the user is not authorized to do this request",
     *         500="Returned on internal server errors"
     *  },
     *  section="User Webservice",
     *  tags={
     *      "stable" = "#000"
     *  }
     *
     * )
     *
     *
     * @Secure(roles="ROLE_API")
     *
     * @param Request $request
     * @return View
     */
    public function deleteApplicationAction(Request $request)
    {
        return $this->apiM()->worker()->Application()->deleteApplication($this->apiM()->client())->init($request);
    }
}
