<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * Class Configuration
 * @package Sso\RestBundle\DependencyInjection
 */
class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritdoc}
     */
    public function getConfigTreeBuilder()
    {
        $validationUrlSchema = function ($v) {
            return !preg_match('#^https?://#i', $v);
        };
        $msgUrlSchema = 'Url must start with "http://" or "https://"!';

        $validationUrlTrailingSlash = function ($v) {
            return preg_match('#/$#', $v);
        };
        $msgTrailingSlash = 'Url must not end with "/"!';

        $validationAction = function ($v) {
            return 0 < strlen($v) && 0 !== strpos($v, '/');
        };
        $msgAction = 'Action should be empty or start with "/"!';

        $treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('sso_rest');
        $rootNode
            ->children()
            ->arrayNode('user_identifier')
            ->children()
            ->scalarNode('base_url')
            ->isRequired()
            ->cannotBeEmpty()
            ->validate()
            ->ifTrue($validationUrlSchema)
            ->thenInvalid($msgUrlSchema)
            ->ifTrue($validationUrlTrailingSlash)
            ->thenInvalid($msgTrailingSlash)
            ->end()
            ->end()
            ->scalarNode('action')
            ->defaultValue('')
            ->validate()
            ->ifTrue($validationAction)
            ->thenInvalid($msgAction)
            ->end()
            ->end()
            ->end()
            ->end()
            ->end();
        $rootNode
            ->children()
            ->arrayNode('user_webservice')
            ->children()
            ->scalarNode('base_url')
            ->isRequired()
            ->cannotBeEmpty()
            ->validate()
            ->ifTrue($validationUrlSchema)
            ->thenInvalid($msgUrlSchema)
            ->ifTrue($validationUrlTrailingSlash)
            ->thenInvalid($msgTrailingSlash)
            ->end()
            ->end()
            ->scalarNode('action')
            ->defaultValue('')
            ->validate()
            ->ifTrue($validationAction)
            ->thenInvalid($msgAction)
            ->end()
            ->end()
            ->end()
            ->end()
            ->end();
        $rootNode
            ->children()
            ->arrayNode('object_webservice')
            ->children()
            ->scalarNode('base_url')
            ->isRequired()
            ->cannotBeEmpty()
            ->validate()
            ->ifTrue($validationUrlSchema)
            ->thenInvalid($msgUrlSchema)
            ->ifTrue($validationUrlTrailingSlash)
            ->thenInvalid($msgTrailingSlash)
            ->end()
            ->end()
            ->scalarNode('action')
            ->defaultValue('')
            ->validate()
            ->ifTrue($validationAction)
            ->thenInvalid($msgAction)
            ->end()
            ->end()
            ->end()
            ->end()
            ->end();
        $rootNode
            ->children()
            ->arrayNode('scope_config')
            ->children()
            ->scalarNode('scope_application_name')->isRequired()->cannotBeEmpty()->end()
            ->arrayNode('scope_attributes')
            ->prototype('scalar')
            ->end()
            ->end()
            ->end()
            ->end();

        return $treeBuilder;
    }
}
